#include "univ.h"

static unsigned char inputbuf[BUFSIZ];
static unsigned char *inputlast, *inputp;
static XtInputId hostinputid;

GetRemote()
{
	int i;

	if (inputp == inputlast) {
		i = read(0, inputbuf, sizeof(inputbuf));
		if (i <= 0) {
			fprintf(stderr, "GetRemote error\n");
			exit(1);
		}
		inputlast = &inputbuf[i];
		inputp = inputbuf;
	}
	return *inputp++;
}

void hostreadCB(data, source, id)
caddr_t data;
int *source;
XtInputId *id;
{
	register int op;
	int i;

	i = read(0, inputbuf, sizeof(inputbuf));
	if (i <= 0)
		exit(1);
	inputlast = &inputbuf[i];
	inputp = inputbuf;
Again:
	while(inputp != inputlast){
		op = GetRemote();
		switch (op&0xF0){
		case (int)P_VERSION&0xF0:
			if (op==(int)P_QUIT)
				exit(0);
			else if (op == (int)P_ERROR)
				HostError();
			else if (RcvLong() != PADS_VERSION)
			   ProtoErr("pi/pads versions differ - regenerate.");
			break;
		case (int)P_PICK&0xF0:
			PickOp();
			break;
		case (int)P_HOSTSTATE&0xF0:
			ShowHostState(op==(int)P_BUSY);
			goto Again;
		case (int)P_PADDEF&0xF0:
		case (int)P_PADOP&0xF0:	
			PadOp(op);
			break;
		case (int)P_CACHEOP&0xF0:
			CacheOp(op);
			break;
		case (int)P_HELPSTR&0xF0:
			HelpString();
			break;
		default:
			ProtoErr( "RCVServe");
		}
	}
}

HelpString()
{
	char s[256];
	char *cp;

	RcvString(s);
	cp = &s[strlen(s)];
	*cp++ = '\n';
	*cp = 0;
	KeyWindowMessage(s);
}

hostsetup()
{
	hostinputid = XtAddInput(0, XtInputReadMask, hostreadCB, NULL);
}

hostclear()
{
	inputp = inputlast;
	XtRemoveInput(hostinputid);
}
